import refreshTokenHelper from "../../../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../../../utils/errorHandlingHelper"
import fetchHelper from "../../../../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  let newObjValue = {}
  if(body.costTypeId) {
    newObjValue = {...newObjValue, 
      M_CostType_ID: {
        id: body.costTypeId,
        tableName: 'M_CostType'
      }
    }
  }
  if(body.acctSchemaId) {
    newObjValue = {...newObjValue, 
      C_AcctSchema_ID: {
        id: body.acctSchemaId,
        tableName: 'C_AcctSchema'
      }
    }
  }
  if(body.costElementId) {
    newObjValue = {...newObjValue, 
      M_CostElement_ID: {
        id: body.costElementId,
        tableName: 'M_CostElement'
      }
    }
  }
  if(body.costingMethodId) {
    newObjValue = {...newObjValue, 
      CostingMethod: {
        id: body.costingMethodId
      }
    }
  }
  if(body.attributeSetInstanceId) {
    newObjValue = {...newObjValue, 
      M_AttributeSetInstance_ID: {
        id: body.attributeSetInstanceId,
        tableName: 'M_AttributeSetInstance'
      }
    }
  }

  if(body.productId) {
    const res: any = await fetchHelper(event, 'models/m_cost', 'POST', token, {
      AD_Org_ID: {
        id: body.organizationId,
        tableName: 'AD_Org'
      },
      isActive: body.isActive,
      description: body.description,
      currentCostPrice: body.currentCostPrice,
      futureCostPrice: body.futureCostPrice,
      cumulatedAmt: body.cumulatedAmt,
      cumulatedQty: body.cumulatedQty,
      percent: body.percent,
      currentQty: body.currentQty,
      currentCostPriceLL: body.currentCostPriceLL,
      futureCostPriceLL: body.futureCostPriceLL,
      isCostFrozen: body.isCostFrozen,
      M_Product_ID: {
        id: body.productId,
        tableName: 'M_Product'
      },
      ...newObjValue,
      tableName: 'm_cost'
    })
    if(res) {
      data = res
      data['status'] = 200
      data['message'] = ''
    }
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error: any) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})